/*
 * Decompiled with CFR 0.152.
 */
package io.github.noeppi_noeppi.libx.impl.config.gui.screen.content;

import com.google.common.collect.ImmutableList;
import io.github.noeppi_noeppi.libx.config.gui.ConfigEditor;
import io.github.noeppi_noeppi.libx.config.gui.ConfigScreenContent;
import io.github.noeppi_noeppi.libx.config.gui.WidgetProperties;
import io.github.noeppi_noeppi.libx.impl.config.gui.EditorHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.IntStream;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.util.Mth;

public class ListContent<T>
implements ConfigScreenContent<List<T>> {
    private final ConfigEditor<T> editor;
    private Consumer<List<T>> inputChanged;
    private final List<T> list;
    private final List<AbstractWidget> widgets;

    public ListContent(List<T> value, ConfigEditor<T> editor) {
        this.editor = editor;
        this.list = new ArrayList<T>(value);
        this.widgets = new ArrayList<AbstractWidget>(IntStream.range(0, this.list.size()).mapToObj(i -> null).toList());
    }

    @Override
    public Component title() {
        return new TranslatableComponent("libx.config.gui.list.title");
    }

    @Override
    public boolean searchable() {
        return false;
    }

    @Override
    public void init(Consumer<List<T>> inputChanged) {
        this.inputChanged = inputChanged;
    }

    private void update() {
        if (this.inputChanged != null) {
            this.inputChanged.accept((List<ImmutableList>)ImmutableList.copyOf(this.list));
        }
    }

    @Override
    public void buildGui(Screen screen, final ConfigScreenContent.ScreenManager manager, String search, Consumer<AbstractWidget> consumer) {
        int y = 0;
        for (int i = 0; i < this.list.size(); ++i) {
            this.addEntryWidgets(screen, manager, consumer, i, y);
            y += 23;
        }
        int width = 269;
        int padding = Math.max(0, screen.f_96543_ - width) / 2;
        Button button = new Button(padding, y, 100, 20, (Component)new TranslatableComponent("libx.config.gui.list.new"), b -> {}){

            public void m_5691_() {
                ListContent.this.list.add(ListContent.this.editor.defaultValue());
                ListContent.this.widgets.add(null);
                ListContent.this.update();
                manager.rebuild();
            }
        };
        consumer.accept((AbstractWidget)button);
    }

    private void addEntryWidgets(Screen screen, ConfigScreenContent.ScreenManager manager, Consumer<AbstractWidget> consumer, int idx, int y) {
        int width = 269;
        int padding = Math.max(0, screen.f_96543_ - width) / 2;
        WidgetProperties<Object> properties = new WidgetProperties<Object>(padding, y, 200, 20, t -> {
            this.list.set(idx, t);
            this.update();
        });
        AbstractWidget widget = EditorHelper.create(screen, this.editor, this.list.get(idx), this.widgets.get(idx), properties);
        this.widgets.set(idx, widget);
        consumer.accept(widget);
        ListContent.addControlButton(consumer, padding + 203, y, (Component)new TextComponent("\u2b06"), idx > 0, () -> {
            ListContent.move(this.list, idx, idx - 1);
            ListContent.move(this.widgets, idx, idx - 1);
            this.update();
            manager.rebuild();
        });
        ListContent.addControlButton(consumer, padding + 226, y, (Component)new TextComponent("\u2b07"), idx < this.list.size() - 1, () -> {
            ListContent.move(this.list, idx, idx + 1);
            ListContent.move(this.widgets, idx, idx + 1);
            this.update();
            manager.rebuild();
        });
        ListContent.addControlButton(consumer, padding + 249, y, (Component)new TextComponent("\u2716").m_130940_(ChatFormatting.RED), true, () -> {
            this.list.remove(idx);
            this.widgets.remove(idx);
            this.update();
            manager.rebuild();
        });
    }

    public static void addControlButton(Consumer<AbstractWidget> consumer, int x, int y, Component text, boolean enable, final Runnable action) {
        Button button = new Button(x, y, 20, 20, text, b -> {}){

            public void m_5691_() {
                action.run();
            }
        };
        button.f_93623_ = enable;
        consumer.accept((AbstractWidget)button);
    }

    public static <T> void move(List<T> list, int from0, int to0) {
        int from = Mth.m_14045_((int)from0, (int)0, (int)(list.size() - 1));
        int to = Mth.m_14045_((int)to0, (int)0, (int)(list.size() - 1));
        T elem = list.remove(from);
        list.add(list.get(list.size() - 1));
        for (int i = list.size() - 2; i >= to && i > 0; --i) {
            list.set(i, list.get(i - 1));
        }
        list.set(to, elem);
    }
}

